/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;

public class ComponentPrintable
implements Printable {
    private Component mComponent;

    public ComponentPrintable(Component component) {
        this.mComponent = component;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        boolean bl = this.disableDoubleBuffering(this.mComponent);
        double d = pageFormat.getImageableWidth() / (double)this.mComponent.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.mComponent.getHeight();
        double d3 = Math.min(d, d2);
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        graphics2D.scale(d3, d3);
        this.mComponent.print(graphics2D);
        this.restoreDoubleBuffering(this.mComponent, bl);
        return 0;
    }

    private boolean disableDoubleBuffering(Component component) {
        if (!(component instanceof JComponent)) {
            return false;
        }
        JComponent jComponent = (JComponent)component;
        boolean bl = jComponent.isDoubleBuffered();
        jComponent.setDoubleBuffered(false);
        return bl;
    }

    private void restoreDoubleBuffering(Component component, boolean bl) {
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(bl);
        }
    }
}

