function [] = catchError(handles)
%%CATCHERROR Identifies error and displays appropriate msg box.
%
% Error messages are collected in the structure errormsg.
%
% AP - 24 Sep 2014.

% Collect user inputs
RGratio = str2double(get(handles.r2g_box,'String'));
BGratio = str2double(get(handles.b2g_box,'String'));
noise = str2double(get(handles.noise_box,'String'));
trim_initial = str2double(get(handles.trim_initial_box,'String'));
trim_last = str2double(get(handles.trim_last_box,'String')); % Remove last frames of video.
stepFrame = str2double(get(handles.step_box,'String'));

% Check installation of image processing toolbox
if ~license('test','image_toolbox');
    errormsg.image_toolbox = '- Matlab image processing toolbox is not available';
end

% Check Input file existence and extension format. 
if ~handles.input_filename_exists
   set(handles.statusbox,'String','Please load files');drawnow
   errormsg.input_empty = '- No input files detected. Please, load one or more supported files';
elseif ~ismember(lower(handles.input_ext),[lower(handles.video_ext),lower(handles.image_ext)])
       errormsg.input_ext = '- Invalid input file extension. Please load a valid file extension: .TIFF, .TIF, .JPEG, .JPG, .PNG, .AVI, .WMV, .MPEG, or .MP4';  
end
 
% % Check Output file existence and extension format. 
if ~handles.output_filename_exists
       set(handles.statusbox,'String','Please select an output directory');drawnow
       errormsg.output_empty = '- Please select an output directory';
elseif ~ismember(lower(handles.selected_output_ext), {'.txt'})
       errormsg.output_ext = '- Invalid output extension. Please choose a valid output extension: .txt';
end   
   
% Check RGratio 
if RGratio < 0
   set(handles.r2g_box,'String','1');
   errormsg.RGratio_less_zero = '- "Red/Green" must be positive';
elseif isempty(RGratio) || isnan(RGratio)
       set(handles.r2g_box,'String','1');
       errormsg.RGratio_empty = '- "Red/Green" must be a positive number and cannot be empty';
end       

% Check BGratio 
if BGratio < 0
   errormsg.BGratio_less_zero = '- "Blue/Green" must be a positive';
   set(handles.b2g_box,'String','1');
elseif isempty(BGratio) || isnan(BGratio) 
       set(handles.b2g_box,'String','1');   
       errormsg.BGratio_empty = '- "Blue/Green" must be a positive number and cannot be empty';
end 

% Check Noise
if isempty(noise) || isnan(noise) ;
   set(handles.noise_box,'String','1');
   errormsg.Noise_empty = '- "Noise reduction" must be a positive integer and cannot be empty';
elseif noise < 1 || noise ~= floor(noise)
       errormsg.Noise_less_zero = '- "Noise reduction" must be a positive integer';
       set(handles.noise_box,'String','1');
end

% Check trim_initial
if trim_initial < 0
   set(handles.trim_initial_box,'String','0');
   errormsg.trim_initial_less_zero = '- "Trim initial frames" must be a positive integer';
elseif isempty(trim_initial) || isnan(trim_initial)
       set(handles.trim_initial_box,'String','0');
       errormsg.trim_initial_empty = '- "Trim initial frames" must be a positive integer and cannot be empty';
elseif trim_initial ~= floor(trim_initial)
       set(handles.trim_initial_box,'String','1');
       errormsg.trim_initial_integer = '- "Trim initial frames" must be a positive integer'; 
end 

% Check trim_last
if trim_last < 0
       set(handles.trim_last_box,'String','0');
       errormsg.trim_last_less_zero = '- "Trim last frames" must be a positive integer';
elseif isempty(trim_last) || isnan(trim_last) 
       set(handles.trim_last_box,'String','0');
       errormsg.trim_last_empty = '- "Trim last frames" must be a positive integer and cannot be empty';
elseif trim_last ~= floor(trim_last)
       set(handles.trim_last_box,'String','1');
       errormsg.trim_last_integer = '- "Trim last frames" must be a positive integer'; 
end 

% Check stepFrame
if isempty(stepFrame) || isnan(stepFrame) 
   set(handles.step_box,'String','1');
   errormsg.step_empty = '- "Step" must be a possitive integer equal or higher than 1 and cannot be empty';
elseif stepFrame < 1
       set(handles.step_box,'String','1');
       errormsg.step_less_one = '- "Step" must be a positive integer equal or higher than 1';
elseif stepFrame ~= floor(stepFrame)
       set(handles.step_box,'String','1');
       errormsg.step_integer = '- "Step" must be a positive integer equal or higher than 1'; 
end 

% Check video inputs
if isfield(handles, 'input_ext') && isfield(handles, 'totalFrames')
    if ismember(lower(handles.input_ext),lower(handles.video_ext))
        if trim_initial + trim_last >= handles.totalFrames
            errormsg.trim_large = ['- Trimmed frames exceed the total number of frames in video:',' ',handles.filenames{handles.i,1}]; 
        end
    end
end

% Display detected errors
errormsgtype = 'Warning';
if exist('errormsg','var')
    errormsg = struct2cell(errormsg);
    h = msgbox(errormsg, errormsgtype);
    set(handles.togglebuttonrun,'String','Run')
    set(handles.togglebuttonrun,'Value',0);
    set(handles.statusbox,'String','');
else
    msgbox('Unknown error - Please contact support@canopeoapp.com','Error')
    set(handles.statusbox,'String','');
    set(handles.togglebuttonrun,'String','Run')
    set(handles.togglebuttonrun,'Value',0);
end
   
