function [] = save_summary_output(filename_output, output_matrix)

% Open output file
fileID = fopen(filename_output,'w');

% Check if file is open
if fileID ~= -1
    fclose(fileID);
else
    while (fileID == -1)
        errormsg = strcat('The file: ', filename_output, ' is open. Please close it to continue saving your data');
        waitfor(msgbox(errormsg,'Error'));
        fileID = fopen(filename_output, 'w');
    end
    fclose(fileID);
end

fileID = fopen(filename_output,'w');

% Set format of data
formatSpecRatios = '%s,%.3f,%s,%s\r\n';
formatSpecNoise = '%s,%d,%s,%s\r\n';
formatSpecFilePath = '%s,%s,%s,%s\r\n';
formatSpecDate = '%s,%s,%s,%s\r\n';
formatSpecHeaders = '%s,%s,%s,%s\r\n';
formatSpecData = '%s,%.3f,%.3f,%.3f\r\n';

nrows = size(output_matrix,1);

% Write rows in file
fprintf(fileID,formatSpecRatios,output_matrix{1,:}); % Write RG ratio
fprintf(fileID,formatSpecRatios,output_matrix{2,:}); % Write BG ratio
fprintf(fileID,formatSpecNoise,output_matrix{3,:}); % Write Noise reduction
fprintf(fileID,formatSpecFilePath,output_matrix{4,:}); % Write File path
fprintf(fileID,formatSpecDate,output_matrix{5,:}); % Write current date
fprintf(fileID,formatSpecHeaders,output_matrix{6,:}); % Write Headers
for row = 7:nrows
    fprintf(fileID,formatSpecData,output_matrix{row,:});
end

fclose(fileID);