function [image_uint8,image_binary,percent_canopy,handles] = imageSelector (handles)
%%RANDOMIMAGE selectes the green pixels of a random image from a given set 
%%of images chosen by the user.
%
% Andres Patrignani and Tyson Ochsner, Dec 2014.

% Select image or frame
if ismember(lower(handles.input_ext),lower({'.TIFF', '.TIF', '.JPEG', '.JPG', '.PNG'}))
    imageVector = 1:handles.numfiles;
    if handles.imageSelector == 1 % Forward
        handles.imageCounter = min(max(handles.imageCounter + 1, 1), handles.numfiles);
    else
        handles.imageCounter = min(max(handles.imageCounter - 1, 1), handles.numfiles);
    end
    handles.i = imageVector(handles.imageCounter);
    image_uint8 = imread(handles.fullfilenames{handles.i,1}); % read random image.
    
else
    % Using frames only for the first video. handles.videoFrames is in the input button.
    imageVector = 1:handles.videoFrames;
        if handles.imageSelector == 1 % Forward
            handles.imageCounter = min(handles.imageCounter + 1, length(imageVector));
        else
            handles.imageCounter = max(handles.imageCounter - 1, 1);
        end
    handles.i = imageVector(handles.imageCounter);
    mov.cdata = read(handles.xyloObj, handles.i); % mov is the structure that stores the extracted frames.
    image_uint8 = mov.cdata;    
end

[image_binary, percent_canopy] = imageAnalysis(image_uint8, handles); % Extract green pixels using imageAnalysis.
end