function [RGratio,BGratio,noise] = ratios(handles)
%%RATIOS get values of RG, BGe, an noise from edit boxes in the GUI. 
%
% Andres Patrignani and Tyson Ochsner, Dec 2014.

% Set ratios
RGratio = str2double(get(handles.r2g_box,'String'));
BGratio = str2double(get(handles.b2g_box,'String'));
noise = str2double(get(handles.noise_box,'String'));

% Check RGratio 
assert(isnumeric(RGratio) && isnumeric(BGratio) && isnumeric(noise));
assert(~isnan(RGratio) && ~isnan(BGratio) && ~isnan(noise));   
assert(RGratio >= 0 && BGratio >= 0 && RGratio >= 0);